<?php

require_once '../model/database.php';
require_once '../model/product_model.php';
require_once '../model/vendor_model.php';
require_once 'header.php';

$errors = [];
$inputData = [];

// Check if editing an existing product
if (isset($_GET['product_id'])) {
    $prod_id = $_GET['product_id'];
    $product = get_product_by_id($conn, $prod_id);  // Fetch product details

    // If product doesn't exist, show an error message
    if (!$product) {
        echo "<p>Product not found.</p>";
        exit;
    }
} else {
    $product = null; // No product selected (creating a new one)
}

$vendors = get_all_vendors($conn);  // Fetch vendor names for the dropdown

echo "<h1>" . ($product ? "Edit Product" : "Add New Product") . "</h1>";
echo "<nav><a href='../index.php'>Home</a> | <a href='product_info.php'>Product Info</a> | <a href='manage_products.php'>Products</a></nav>";

if (isset($_POST['add'])) {
    // Collect input data from the form
    $inputData = [
        'prod_id' => trim($_POST['prod_id']),
        'prod_name' => trim($_POST['prod_name']),
        'prod_price' => trim($_POST['prod_price']),
        'prod_desc' => trim($_POST['prod_desc']),
        'vend_name' => trim($_POST['vend_name']),  // Using vend_name instead of vend_id
    ];

    // Find the corresponding vend_id based on the selected vendor name
    $vend_id = null;
    foreach ($vendors as $vendor) {
        if ($vendor['vend_name'] === $inputData['vend_name']) {
            $vend_id = $vendor['vend_id'];
            break;
        }
    }

    // Validation logic
    if (empty($inputData['prod_id'])) {
        $errors['prod_id'] = "Product ID is required.";
    }

    if (empty($inputData['prod_name'])) {
        $errors['prod_name'] = "Product Name is required.";
    } elseif (strlen($inputData['prod_name']) > 255) {
        $errors['prod_name'] = "Product Name cannot exceed 255 characters.";
    }

    if (empty($inputData['prod_price'])) {
        $errors['prod_price'] = "Product Price is required.";
    } elseif (!is_numeric($inputData['prod_price'])) {
        $errors['prod_price'] = "Product Price must be numeric.";
    }

    if (!empty($inputData['prod_desc']) && strlen($inputData['prod_desc']) > 500) {
        $errors['prod_desc'] = "Product Description cannot exceed 500 characters.";
    }

    if (empty($inputData['vend_name'])) {
        $errors['vend_name'] = "Vendor Name is required.";
    }

    // If no errors, either add or update the product
    if (empty($errors)) {
        if ($product) {
            // Update existing product
            update_product($conn, $inputData['prod_id'], $inputData['prod_name'], $inputData['prod_price'], $inputData['prod_desc'], $vend_id);
            echo "<p>Product updated successfully.</p>";
        } else {
            // Add new product
            add_product($conn, $inputData['prod_id'], $inputData['prod_name'], $inputData['prod_price'], $inputData['prod_desc'], $vend_id);
            echo "<p>Product added successfully.</p>";
        }
    }
}

?>

<form method="post">
    <label>Product ID: <input type="text" name="prod_id" value="<?php echo htmlspecialchars($product ? $product['prod_id'] : $inputData['prod_id']); ?>">
        <?php if (isset($errors['prod_id'])) echo "<span class='error-msg'>" . $errors['prod_id'] . "</span>"; ?>
    </label><br>

    <label>Product Name: <input type="text" name="prod_name" value="<?php echo htmlspecialchars($product ? $product['prod_name'] : $inputData['prod_name']); ?>">
        <?php if (isset($errors['prod_name'])) echo "<span class='error-msg'>" . $errors['prod_name'] . "</span>"; ?>
    </label><br>

    <label>Product Price: 
        <input type="text" name="prod_price" value="<?php echo htmlspecialchars($product ? number_format($product['prod_price'], 2) : number_format($inputData['prod_price'], 2)); ?>">
        <?php if (isset($errors['prod_price'])) echo "<span class='error-msg'>" . $errors['prod_price'] . "</span>"; ?>
    </label><br>

    <label>Product Description: <textarea name="prod_desc"><?php echo htmlspecialchars($product ? $product['prod_desc'] : $inputData['prod_desc']); ?></textarea>
        <?php if (isset($errors['prod_desc'])) echo "<span class='error-msg'>" . $errors['prod_desc'] . "</span>"; ?>
    </label><br>

    <label>Vendor:
        <select name="vend_name">
            <?php foreach ($vendors as $vendor) { ?>
                <option value="<?php echo $vendor['vend_name']; ?>" 
                    <?php 
                    // For an existing product, check if the vend_name matches the product's vend_name
                    if ($product && $vendor['vend_name'] == $product['vend_name']) {
                        echo 'selected';
                    } elseif (!$product && $vendor['vend_name'] == $inputData['vend_name']) {
                        // For a new product, check if the vendor is selected from the posted data
                        echo 'selected';
                    }
                    ?>>
                    <?php echo $vendor['vend_name']; ?>
                </option>
            <?php } ?>
        </select>
        <?php if (isset($errors['vend_name'])) echo "<span class='error-msg'>" . $errors['vend_name'] . "</span>"; ?>
    </label><br>

    <input type="submit" name="add" value="<?php echo $product ? 'Update Product' : 'Add Product'; ?>">
</form>

<?php
require_once 'footer.php';
?>
